function digits(s){ 
  return String(s || "").replace(/\D/g,""); 
}

function fmt(raw, pos){
  if (!(pos > 0 && pos < raw.length)) return raw;
  return raw.slice(0, pos) + "," + raw.slice(pos);
}

function Decode(fPort, bytes, variables){
  var raw = "";
  for (var i = 0; i < bytes.length; i++) raw += String.fromCharCode(bytes[i]);

  
  var m10 = raw.match(
    /^(\d+)\|([^\|]+)\|(\d+)\|(\d+)\|([0-9A-Fa-f]{4})\|([0-9A-Fa-f]{4})\|([0-9A-Fa-f]{4})\|(-?\d+)\|(-?\d+)\|(-?\d+)$/
  );

  
  var m11 = raw.match(
    /^(\d+)\|([^\|]+)\|(\d+)\|(\d+)\|([0-9A-Fa-f]{16})\|([0-9A-Fa-f]{4})\|([0-9A-Fa-f]{4})\|([0-9A-Fa-f]{4})\|(-?\d+)\|(-?\d+)\|(-?\d+)$/
  );

  
  var m7 = raw.match(
    /^(\d+)\|([^\|]+)\|(\d+)\|(\d+)\|([0-9A-Fa-f]{4})\|([0-9A-Fa-f]{4})\|([0-9A-Fa-f]{4})$/
  );

  var m8 = raw.match(
    /^(\d+)\|([^\|]+)\|(\d+)\|(\d+)\|([0-9A-Fa-f]{16})\|([0-9A-Fa-f]{4})\|([0-9A-Fa-f]{4})\|([0-9A-Fa-f]{4})$/
  );

  var m4 = raw.match(/^(\d+)\|([^\|]+)\|(\d+)\|(\d+)$/);
  var m3 = raw.match(/^(\d+)\|([^\|]+)\|(\d+)$/);
  var m2 = raw.match(/^(\d+)\|(.*)$/);

  var pos   = 0;
  var val   = "";
  var batt  = null;
  var mv    = null;

  var errHex   = null;
  var warnHex  = null;
  var infoHex  = null;

  var imu_ax = null;
  var imu_ay = null;
  var imu_az = null;

  if (m10) {
    pos     = parseInt(m10[1], 10) || 0;
    val     = digits(m10[2]);
    batt    = parseInt(m10[3], 10);
    mv      = parseInt(m10[4], 10);

    errHex  = m10[5].toUpperCase();
    warnHex = m10[6].toUpperCase();
    infoHex = m10[7].toUpperCase();

    imu_ax  = parseInt(m10[8], 10);
    imu_ay  = parseInt(m10[9], 10);
    imu_az  = parseInt(m10[10], 10);

  } else if (m11) {
    pos     = parseInt(m11[1], 10) || 0;
    val     = digits(m11[2]);
    batt    = parseInt(m11[3], 10);
    mv      = parseInt(m11[4], 10);

    errHex  = m11[6].toUpperCase();
    warnHex = m11[7].toUpperCase();
    infoHex = m11[8].toUpperCase();

    imu_ax  = parseInt(m11[9], 10);
    imu_ay  = parseInt(m11[10], 10);
    imu_az  = parseInt(m11[11], 10);

  } else if (m7) {
    pos     = parseInt(m7[1], 10) || 0;
    val     = digits(m7[2]);
    batt    = parseInt(m7[3], 10);
    mv      = parseInt(m7[4], 10);

    errHex  = m7[5].toUpperCase();
    warnHex = m7[6].toUpperCase();
    infoHex = m7[7].toUpperCase();

  } else if (m8) {
    pos     = parseInt(m8[1], 10) || 0;
    val     = digits(m8[2]);
    batt    = parseInt(m8[3], 10);
    mv      = parseInt(m8[4], 10);

    errHex  = m8[6].toUpperCase();
    warnHex = m8[7].toUpperCase();
    infoHex = m8[8].toUpperCase();

  } else if (m4) {
    pos  = parseInt(m4[1], 10) || 0;
    val  = digits(m4[2]);
    batt = parseInt(m4[3], 10);
    mv   = parseInt(m4[4], 10);

  } else if (m3) {
    pos  = parseInt(m3[1], 10) || 0;
    val  = digits(m3[2]);
    batt = parseInt(m3[3], 10);

  } else if (m2) {
    pos  = parseInt(m2[1], 10) || 0;
    val  = digits(m2[2]);

  } else {
    pos = parseInt(variables && (variables.comma_pos || variables.comma), 10) || 0;
    val = digits(raw);
  }

  return {
    message           : fmt(val, pos),
    comma_pos         : pos,
    total_digits      : val.length,
    battery_pct       : batt,
    battery_mv        : mv,
    error_event_hex   : errHex,
    warning_event_hex : warnHex,
    info_event_hex    : infoHex,
    imu_ax            : imu_ax,
    imu_ay            : imu_ay,
    imu_az            : imu_az
  };
}

function decodeUplink(input) {
  var out = Decode(input.fPort, input.bytes, (input.variables || {}));

  return {
    data: {
      meterValue        : out.message,
      comma_pos         : out.comma_pos,
      total_digits      : out.total_digits,
      battery_pct       : out.battery_pct,
      battery_mv        : out.battery_mv,
      error_event_hex   : out.error_event_hex,
      warning_event_hex : out.warning_event_hex,
      info_event_hex    : out.info_event_hex,
      imu_ax            : out.imu_ax,
      imu_ay            : out.imu_ay,
      imu_az            : out.imu_az
    }
  };
}
